import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:get/get.dart';
import 'package:nb_utils/nb_utils.dart';
import 'package:streamit_laravel/components/app_scaffold.dart';
import 'package:streamit_laravel/configs.dart';
import 'package:streamit_laravel/main.dart';
import 'package:streamit_laravel/screens/auth/model/about_page_res.dart';
import 'package:streamit_laravel/utils/app_common.dart';
import 'package:streamit_laravel/utils/colors.dart';
import 'package:streamit_laravel/utils/constants.dart';
import 'package:streamit_laravel/utils/country_picker/country_list.dart';
import 'package:streamit_laravel/utils/country_picker/country_utils.dart';
import 'package:streamit_laravel/generated/assets.dart';

import '../../../components/cached_image_widget.dart';
import '../../../utils/common_base.dart';
import '../../profile/profile_controller.dart';
import '../sign_in/sign_in_controller.dart';
import 'component/social_auth.dart';

class SignInScreen extends StatelessWidget {
  // ignore: use_super_parameters
  final bool showBackButton;

  SignInScreen({super.key, this.showBackButton = true});

  final SignInController signInController = Get.put(SignInController());
  final ProfileController profileCont = Get.put(ProfileController());

  @override
  Widget build(BuildContext context) {
    return AppScaffoldNew(
      scaffoldBackgroundColor: appScreenBackgroundDark,
      topBarBgColor: transparentColor,
      isLoading: signInController.isLoading,
      body: SingleChildScrollView(
        child: Form(
          key: signInController.signInformKey,
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.center,
            mainAxisAlignment: MainAxisAlignment.start,
            children: [
              SizedBox(height: Get.height * 0.05),
              const Align(
                alignment: Alignment.center,
                child: CachedImageWidget(
                  url: Assets.assetsAppLogo,
                  height: 41,
                ),
              ),
              50.height,
              Text(locale.value.welcomeBackToStreamIt, style: commonW500PrimaryTextStyle(size: 20)),
              8.height,
              Text(locale.value.weHaveEagerlyAwaitedYourReturn, style: secondaryTextStyle()),
              40.height,
              Obx(
                () => Row(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    InkWell(
                      onTap: () {
                        signInController.changeCountry(context);
                      },
                      child: Container(
                        padding: const EdgeInsets.symmetric(vertical: 12),
                        decoration: boxDecorationDefault(
                          borderRadius: BorderRadiusDirectional.zero,
                          border: Border(bottom: BorderSide(color: borderColor.withValues(alpha: 0.6))),
                          color: appScreenBackgroundDark,
                        ),
                        child: Row(
                          children: [
                            Text(signInController.selectedCountry.value.flagEmoji, style: primaryTextStyle(size: 20)),
                            6.width,
                            Text(signInController.countryCode.value, style: primaryTextStyle()),
                            6.width,
                            const Icon(
                              Icons.arrow_drop_down,
                              color: iconColor,
                            )
                          ],
                        ),
                      ),
                    ),
                    16.width,
                    AppTextField(
                      textStyle: primaryTextStyle(),
                      controller: signInController.phoneCont,
                      textFieldType: TextFieldType.PHONE,
                      cursorColor: white,
                      maxLength: getValidPhoneNumberLength(CountryModel.fromJson(signInController.selectedCountry.value.toJson())),
                      inputFormatters: [FilteringTextInputFormatter.digitsOnly],
                      validator: (mobileCont) {
                        if (mobileCont!.isEmpty) {
                          return locale.value.phnRequiredText;
                        } else if (!validatePhoneNumberByCountry(signInController.phoneCont.text, CountryModel.fromJson(signInController.selectedCountry.value.toJson()))) {
                          return locale.value.pleaseEnterAValidMobileNo;
                        }
                        return null;
                      },
                      decoration: inputDecoration(
                        context,
                        contentPadding: const EdgeInsets.only(top: 14),
                        hintText: locale.value.mobileNumber,
                        prefixIcon: Image.asset(
                          Assets.iconsIcPhone,
                          color: iconColor,
                          height: 12,
                          width: 12,
                        ).paddingAll(16),
                      ),
                      onChanged: (value) {
                        signInController.getBtnEnable();
                      },
                      onFieldSubmitted: (value) {
                        if (signInController.signInformKey.currentState!.validate()) {
                          hideKeyboard(context);
                          signInController.isPhoneAuthLoading(true);
                          signInController.checkIfDemoUser(
                            callBack: () {
                              signInController.onLoginPressed();
                            },
                          );
                        }
                      },
                    ).expand(flex: 3)
                  ],
                ),
              ),
              24.height,
              Obx(
                () => AppButton(
                  onTap: () {
                    if (signInController.signInformKey.currentState!.validate()) {
                      hideKeyboard(context);
                      signInController.isPhoneAuthLoading(true);
                      signInController.checkIfDemoUser(
                        callBack: () {
                          signInController.onLoginPressed();
                        },
                      );
                    }
                  },
                  width: Get.width,
                  color: signInController.isBtnEnable.isTrue ? appColorPrimary : lightBtnColor,
                  textStyle: appButtonTextStyleWhite,
                  shapeBorder: RoundedRectangleBorder(borderRadius: radius(4)),
                  child: Text(locale.value.getVerificationCode, style: boldTextStyle()),
                ),
              ),
              40.height,
              Row(
                children: [
                  const Divider(
                    indent: 24,
                    endIndent: 24,
                    height: 4,
                    color: borderColor,
                  ).expand(),
                  Text(locale.value.or, style: secondaryTextStyle()),
                  const Divider(
                    indent: 24,
                    endIndent: 24,
                    height: 8,
                    color: borderColor,
                  ).expand(),
                ],
              ),
              28.height,
              SocialAuthComponent(),
              48.height,
              Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  Expanded(
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        GestureDetector(
                          onTap: () {
                            final AboutDataModel aboutDataModel = appPageList.firstWhere((element) => element.slug == AppPages.termsAndCondition);
                            if (aboutDataModel.url.validate().isNotEmpty) launchUrlCustomURL(aboutDataModel.url.validate());
                          },
                          child: Wrap(
                            alignment: WrapAlignment.center,
                            children: [
                              Text('${locale.value.bySigningYouAgreeTo} $APP_NAME ', style: commonW500SecondaryTextStyle()),
                              Text('${locale.value.termsConditions} ', style: commonW500SecondaryTextStyle(color: appColorPrimary)),
                              Text(locale.value.ofAll, style: commonW500SecondaryTextStyle()),
                            ],
                          ),
                        ),
                        GestureDetector(
                          onTap: () {
                            final AboutDataModel aboutDataModel = appPageList.firstWhere((element) => element.slug == AppPages.privacyPolicy);
                            if (aboutDataModel.url.validate().isNotEmpty) launchUrlCustomURL(aboutDataModel.url.validate());
                          },
                          child: Wrap(
                            alignment: WrapAlignment.center,
                            children: [
                              Text(locale.value.servicesAnd, style: commonW500SecondaryTextStyle()),
                              Text(locale.value.privacyPolicy, style: commonW500SecondaryTextStyle(color: appColorPrimary)),
                            ],
                          ),
                        )
                      ],
                    ),
                  ),
                ],
              ),
            ],
          ).paddingSymmetric(horizontal: 24),
        ),
      ),
    );
  }
}